# Деплой Next.js на cPanel с Node.js

## Ваш хостинг поддерживает Node.js! ✅

Вижу "Setup Node.js App" в вашей панели - это значит можно развернуть Next.js напрямую.

## Шаг 1: Подготовка проекта

### 1.1 Создайте production build локально

```bash
npm run build
```

### 1.2 Создайте архив проекта

Заархивируйте ВСЕ файлы проекта (кроме node_modules):

```bash
# Windows PowerShell
Compress-Archive -Path * -DestinationPath rsash-website.zip -Exclude node_modules,.next,out
```

Или вручную создайте ZIP архив со следующими файлами:
- `app/` (вся папка)
- `components/` (вся папка)
- `dictionaries/` (вся папка)
- `lib/` (вся папка)
- `public/` (вся папка)
- `styles/` (вся папка)
- `package.json`
- `package-lock.json`
- `next.config.js`
- `middleware.ts`
- `tsconfig.json`
- `tailwind.config.ts`
- `postcss.config.js`
- `.env` (если есть)

⚠️ **НЕ включайте:**
- `node_modules/`
- `.next/`
- `out/`
- `.git/`

## Шаг 2: Загрузка на сервер

### 2.1 Подключитесь к File Manager

1. В cPanel откройте **File Manager**
2. Перейдите в папку `public_html` или создайте отдельную папку (например, `rsash-website`)
3. Загрузите `rsash-website.zip`
4. Кликните правой кнопкой → **Extract** (Распаковать)

## Шаг 3: Настройка Node.js приложения

### 3.1 Откройте "Setup Node.js App"

В cPanel найдите и откройте **"Setup Node.js App"**

### 3.2 Создайте новое приложение

Заполните форму:

| Поле | Значение |
|------|----------|
| **Node.js version** | 18.x или выше (рекомендую 20.x) |
| **Application mode** | Production |
| **Application root** | `/home/ваш_юзер/rsash-website` (путь к папке с проектом) |
| **Application URL** | `yourdomain.com` или поддомен |
| **Application startup file** | `server.js` |
| **Passenger log file** | оставьте по умолчанию |

⚠️ **Важно:** Application root - это полный путь к папке, где находится `package.json`

### 3.3 Сохраните и скопируйте команду

После создания приложения вы увидите команду для входа в виртуальное окружение Node.js, например:

```bash
source /home/username/nodevenv/rsash-website/18/bin/activate && cd /home/username/rsash-website
```

## Шаг 4: Установка зависимостей

### 4.1 Откройте Terminal в cPanel

В cPanel найдите **Terminal** (может называться "SSH Access" или "Terminal")

### 4.2 Выполните команды

```bash
# 1. Активируйте окружение Node.js (используйте команду из шага 3.3)
source /home/username/nodevenv/rsash-website/18/bin/activate

# 2. Перейдите в папку проекта
cd /home/username/rsash-website

# 3. Установите зависимости
npm install

# 4. Соберите проект для production
npm run build
```

## Шаг 5: Создайте server.js

В корне проекта (через File Manager → Edit или через Terminal):

```bash
nano server.js
```

Вставьте следующий код:

```javascript
const { createServer } = require('http')
const { parse } = require('url')
const next = require('next')

const dev = process.env.NODE_ENV !== 'production'
const hostname = 'localhost'
const port = process.env.PORT || 3000

const app = next({ dev, hostname, port })
const handle = app.getRequestHandler()

app.prepare().then(() => {
  createServer(async (req, res) => {
    try {
      const parsedUrl = parse(req.url, true)
      await handle(req, res, parsedUrl)
    } catch (err) {
      console.error('Error occurred handling', req.url, err)
      res.statusCode = 500
      res.end('internal server error')
    }
  })
    .once('error', (err) => {
      console.error(err)
      process.exit(1)
    })
    .listen(port, () => {
      console.log(`> Ready on http://${hostname}:${port}`)
    })
})
```

Сохраните: `Ctrl+O`, `Enter`, `Ctrl+X`

## Шаг 6: Обновите package.json

Добавьте скрипт для production:

```json
{
  "scripts": {
    "dev": "next dev",
    "build": "next build",
    "start": "node server.js",
    "lint": "next lint"
  }
}
```

## Шаг 7: Перезапустите приложение

Вернитесь в **"Setup Node.js App"** и нажмите **"Restart"**

## Шаг 8: Настройка домена (опционально)

### Если используете поддомен:

1. В cPanel → **Subdomains**
2. Создайте поддомен (например, `app.yourdomain.com`)
3. Document Root укажите на папку с приложением
4. В "Setup Node.js App" обновите Application URL

### Если используете основной домен:

В `.htaccess` в `public_html`:

```apache
RewriteEngine On
RewriteRule ^$ http://127.0.0.1:3000/ [P,L]
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^(.*)$ http://127.0.0.1:3000/$1 [P,L]
```

## Проверка

Откройте ваш домен в браузере - должен открыться сайт с работающей многоязычностью!

## Обновление сайта

При внесении изменений:

```bash
# 1. Загрузите новые файлы через FTP/File Manager
# 2. Подключитесь к Terminal
source /home/username/nodevenv/rsash-website/18/bin/activate
cd /home/username/rsash-website

# 3. Пересоберите
npm run build

# 4. Перезапустите в "Setup Node.js App"
```

## Возможные проблемы

### Порт уже занят
В `server.js` измените порт на другой (например, 3001, 3002)

### Приложение не запускается
Проверьте логи в cPanel → "Setup Node.js App" → View Log File

### 502 Bad Gateway
Убедитесь что:
- Node.js версия 18+
- Все зависимости установлены (`npm install`)
- Проект собран (`npm run build`)
- Путь к Application root правильный

## Альтернатива: PM2 (для VPS/Dedicated)

Если у вас есть SSH доступ и root права:

```bash
npm install -g pm2
pm2 start server.js --name rsash-website
pm2 startup
pm2 save
```

---

**Поддержка:** Если что-то не работает, проверьте логи в cPanel или напишите в поддержку хостинга.
