# ⚠️ ВАЖНО: FTP хостинг не поддерживается

## Проблема

Этот проект использует **Next.js 14 с App Router и Middleware**, которые требуют **Node.js сервер** для работы. 

**FTP хостинг предоставляет только статический хостинг** (HTML/CSS/JS файлы), который **не поддерживает**:
- ✗ Next.js middleware (для i18n маршрутизации)
- ✗ Server Components  
- ✗ API Routes
- ✗ Dynamic routing
- ✗ ISR/SSR

## Решение: Используйте Node.js хостинг

### Вариант 1: Vercel (РЕКОМЕНДУЕТСЯ) - бесплатно

```bash
# 1. Установите Vercel CLI
npm i -g vercel

# 2. Деплой
vercel

# 3. Следуйте инструкциям в терминале
```

**Преимущества:**
- ✅ Бесплатный план
- ✅ Автоматический SSL
- ✅ CDN по всему миру
- ✅ Автодеплой из Git
- ✅ Полная поддержка Next.js

### Вариант 2: Netlify - бесплатно

```bash
# 1. Установите Netlify CLI
npm i -g netlify-cli

# 2. Деплой
netlify deploy --prod

# 3. Следуйте инструкциям
```

### Вариант 3: Railway - бесплатно (500 часов/месяц)

1. Зарегистрируйтесь на [railway.app](https://railway.app)
2. Подключите GitHub репозиторий
3. Railway автоматически развернет приложение

### Вариант 4: VPS с Node.js

**Дешевые VPS провайдеры:**
- Hetzner (€4.51/мес)
- Contabo (€4.99/мес)
- DigitalOcean (от $6/мес)

**Установка на VPS:**

```bash
# 1. Подключитесь к серверу
ssh root@your-server-ip

# 2. Установите Node.js
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# 3. Клонируйте проект
git clone your-repo.git
cd your-repo

# 4. Установите зависимости
npm install

# 5. Соберите проект
npm run build

# 6. Запустите
npm start
```

**Для production используйте PM2:**

```bash
# Установка PM2
npm i -g pm2

# Запуск
pm2 start npm --name "rsash-website" -- start

# Автозапуск при перезагрузке
pm2 startup
pm2 save
```

## Что делать СЕЙЧАС?

### Быстрое решение (5 минут):

1. **Создайте аккаунт на [vercel.com](https://vercel.com)** (бесплатно)
2. **Подключите GitHub репозиторий** или загрузите проект
3. **Vercel автоматически развернет** ваш сайт
4. **Получите домен** типа `rsash-lab.vercel.app`

### Настройка домена:

После деплоя на Vercel/Netlify:
1. В настройках проекта добавьте свой домен
2. Обновите DNS записи у регистратора домена:
   ```
   Type: CNAME
   Name: @
   Value: cname.vercel-dns.com
   ```

## Если ВСЕ ЖЕ нужен FTP

Для простого статического сайта можно создать версию **без** Next.js - чистый HTML/CSS/JS. Но вы потеряете:
- Автоматическую маршрутизацию
- SEO оптимизацию
- Server-side rendering
- Все преимущества Next.js

**Не рекомендуется для production.**

