import Link from "next/link";
import { Locale } from "@/lib/i18n";

export function Footer({ lang, dict }: { lang: Locale; dict: any }) {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="bg-bg-dark text-white py-12 md:py-16">
      <div className="container mx-auto px-4 md:px-6 grid grid-cols-1 md:grid-cols-4 gap-8">
        <div className="space-y-4">
          <div className="flex items-center gap-2 font-bold text-xl tracking-tighter">
            <div className="w-8 h-8 rounded-lg bg-brand-primary flex items-center justify-center text-white">
              R
            </div>
            <span>RSaSh Lab</span>
          </div>
          <p className="text-gray-400 text-sm max-w-xs">
            Building the digital infrastructure for modern enterprises. Scalable, secure, and seamless.
          </p>
        </div>

        <div>
          <h4 className="font-semibold mb-4 text-sm uppercase tracking-wider text-gray-400">Products</h4>
          <ul className="space-y-2 text-sm text-gray-300">
            <li><Link href="#" className="hover:text-brand-primary transition-colors">RSaSH Flow</Link></li>
            <li><Link href="#" className="hover:text-brand-primary transition-colors">RSaSH Fleet</Link></li>
            <li><Link href="#" className="hover:text-brand-primary transition-colors">RSaSH Travel</Link></li>
            <li><Link href="#" className="hover:text-brand-primary transition-colors">CorpCloth Weave</Link></li>
            <li><Link href="#" className="hover:text-brand-primary transition-colors">Gravion Orbit</Link></li>
          </ul>
        </div>

        <div>
           <h4 className="font-semibold mb-4 text-sm uppercase tracking-wider text-gray-400">Company</h4>
           <ul className="space-y-2 text-sm text-gray-300">
            <li><Link href={`/${lang}/about`} className="hover:text-brand-primary transition-colors">{dict.about}</Link></li>
            <li><Link href="#" className="hover:text-brand-primary transition-colors">Careers</Link></li>
            <li><Link href="#" className="hover:text-brand-primary transition-colors">Contact</Link></li>
           </ul>
        </div>

        <div>
            <h4 className="font-semibold mb-4 text-sm uppercase tracking-wider text-gray-400">Legal</h4>
            <ul className="space-y-2 text-sm text-gray-300">
                <li><Link href="#" className="hover:text-brand-primary transition-colors">Privacy Policy</Link></li>
                <li><Link href="#" className="hover:text-brand-primary transition-colors">Terms of Service</Link></li>
            </ul>
        </div>
      </div>
      <div className="container mx-auto px-4 md:px-6 mt-12 pt-8 border-t border-gray-800 text-center text-sm text-gray-500">
        © {currentYear} RSaSh Lab. All rights reserved.
      </div>
    </footer>
  );
}
