"use client";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Activity, Car, Globe, Shirt, Zap, ArrowRight, LucideIcon } from "lucide-react";
import { motion } from "framer-motion";
import Image from "next/image";

interface ProductEcosystemProps {
  dict: any;
}

type Product = {
    id: string;
    title: string;
    description: string;
    logo?: string | null;
    icon?: LucideIcon;
    color: string;
    textColor: string;
    badge: string;
}

const products: Product[] = [
  {
    id: "flow",
    title: "RSaSh Flow",
    description: "Enterprise BPM & CRM system for workflow automation and client management.",
    logo: "/logos/rsash-icon.svg", 
    icon: Activity,
    color: "bg-product-flow",
    textColor: "text-product-flow",
    badge: "flow",
  },
  {
    id: "fleet",
    title: "RSaSh Fleet",
    description: "Comprehensive vehicle fleet management, tracking, and maintenance scheduling.",
    logo: "/logos/rsash-fleet.jpg",
    icon: Car,
    color: "bg-product-fleet",
    textColor: "text-product-fleet",
    badge: "fleet",
  },
  {
    id: "travel",
    title: "RSaSh Travel",
    description: "Corporate travel booking engine and tour package management platform.",
    icon: Globe,
    logo: null,
    color: "bg-product-travel",
    textColor: "text-product-travel",
    badge: "travel",
  },
  {
    id: "weave",
    title: "CorpCloth Weave",
    description: "Internal marketplace and inventory system for corporate clothing and assets.",
    icon: Shirt,
    logo: null,
    color: "bg-product-weave",
    textColor: "text-product-weave",
    badge: "weave",
  },
  {
    id: "orbit",
    title: "Gravion Orbit",
    description: "Digital signage and media content distribution platform for physical spaces.",
    logo: "/logos/gravion-logo.png",
    icon: Zap,
    color: "bg-product-orbit",
    textColor: "text-product-orbit",
    badge: "orbit",
  },
];

export function ProductEcosystem({ dict }: ProductEcosystemProps) {
  return (
    <section id="products" className="py-24 bg-white">
      <div className="container px-4 md:px-6">
        <div className="flex flex-col items-center justify-center text-center space-y-4 mb-16">
          <Badge variant="outline" className="px-4 py-1">Ecosystem</Badge>
          <h2 className="text-3xl md:text-4xl font-bold tracking-tighter">{dict.title}</h2>
          <p className="max-w-[700px] text-text-secondary md:text-lg">
            {dict.subtitle}
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {products.map((product, index) => (
             <motion.div
                key={product.id}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
             >
                <Card className="h-full flex flex-col hover:border-brand-primary/50 transition-colors group overflow-hidden">
                    <CardHeader>
                        <div className={`w-14 h-14 rounded-xl ${product.color} bg-opacity-10 flex items-center justify-center mb-4 group-hover:bg-opacity-20 transition-all overflow-hidden relative`}>
                            {product.logo ? (
                                <Image 
                                    src={product.logo} 
                                    alt={product.title} 
                                    width={40} 
                                    height={40} 
                                    className="object-contain" 
                                />
                            ) : (
                                product.icon && <product.icon className={`w-7 h-7 ${product.textColor}`} />
                            )}
                        </div>
                        <Badge variant={product.badge as any} className="w-fit mb-2 uppercase text-[10px] tracking-wider">
                           Production
                        </Badge>
                        <CardTitle>{product.title}</CardTitle>
                    </CardHeader>
                    <CardContent className="flex-grow">
                        <CardDescription className="text-base">
                            {product.description}
                        </CardDescription>
                    </CardContent>
                    <CardFooter>
                        <Button variant="ghost" className="p-0 hover:bg-transparent hover:underline text-brand-primary">
                            Details <ArrowRight className="ml-2 w-4 h-4" />
                        </Button>
                    </CardFooter>
                </Card>
             </motion.div>
          ))}
          
           {/* "Add New" Card */}
           <motion.div
             initial={{ opacity: 0, y: 20 }}
             whileInView={{ opacity: 1, y: 0 }}
             viewport={{ once: true }}
             transition={{ duration: 0.5, delay: 0.5 }}
           >
             <Card className="h-full flex flex-col justify-center items-center border-dashed border-2 bg-gray-50/50 hover:bg-gray-50 transition-colors cursor-pointer">
                 <div className="text-center p-8">
                     <div className="w-12 h-12 rounded-full bg-gray-200 mx-auto flex items-center justify-center mb-4">
                         <span className="text-2xl text-gray-400">+</span>
                     </div>
                     <h3 className="font-semibold text-text-primary mb-1">{dict.devRequest}</h3>
                     <p className="text-sm text-text-secondary">{dict.addProduct}</p>
                 </div>
             </Card>
           </motion.div>
        </div>
      </div>
    </section>
  );
}
